// All the vertex shader does is copy the multi-texture coordinate over for the 
// fragment shader to use. The attribute array gl_MultiTexCoord0 is not available 
// in the fragment shader so we need to populate the gl_TexCoord[0] value with it. 
// Then the vertex position gets transformed according to the current model view 
// matrix.
attribute vec4 inPosition;
attribute vec2 inUV;
attribute vec2 inUV2;

uniform mat4 mvpMat;
uniform mat3 texMat;
uniform mat3 texMat2;

varying vec2 gUV;
varying vec2 gUV2;

void main()
{		
	gl_Position = mvpMat * inPosition;
    vec3 temp = texMat*vec3(inUV.x, inUV.y, 1);
    gUV = vec2(temp.x, temp.y);
    
   temp = texMat2*vec3(inUV2.x, inUV2.y, 1);
    gUV2 = vec2(temp.x, temp.y);
} 
